<?php

namespace App\Entities\Courses;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Course extends Model 
{

    protected $table = 'courses';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('slug', 'name', 'short_description', 'description', 'duration');

    public function enrollments()
    {
        return $this->hasMany('Enrolment');
    }

    public function plans()
    {
        return $this->hasMany('Plan');
    }

    public function modules()
    {
        return $this->hasMany('Module');
    }

    public function lessons()
    {
        return $this->hasMany('Lesson');
    }

    public function lecturers()
    {
        return $this->belongsToMany('Lecturer');
    }

}